/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.mokos;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import cz.insophy.inplan.plan.ActionActivity;
import cz.insophy.inplan.plan.CumulativeWorkplaceActivity;
import cz.insophy.inplan.plan.Plan;
import cz.insophy.inplan.plan.WorkplaceActivity;
import cz.insophy.inplan.plan.WorkplaceSchedule;
import cz.insophy.inplan.planning.mokos.Operation;
import cz.insophy.inplan.planning.mokos.Processor;
import cz.insophy.inplan.planning.mokos.Scheduler;
import cz.insophy.inplan.planning.mokos.Util;
import cz.insophy.inplan.shop.CumulativeAction;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedRequest;
import cz.insophy.inplan.util.ChangeTrackingSet;
import cz.insophy.inplan.util.DefaultChangeTrackingSet;
import cz.insophy.inplan.util.Tuple;
import cz.insophy.inplan.util.UnmodifiableChangeTrackingSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class WorkplaceBoundUpdater
extends Processor {
    private final Map<Workplace, Long> workplaceBounds = Maps.newIdentityHashMap();
    private final Set<Operation> outputOps = DefaultChangeTrackingSet.create();
    private final Set<Operation> outputOpsView = new UnmodifiableChangeTrackingSet<Operation>((ChangeTrackingSet)this.outputOps);
    private final Multimap<Workplace, Operation> workplaceOperations = HashMultimap.create();
    private ShopConfiguration conf;
    private Plan plan;

    @Override
    public void setScheduler(Scheduler scheduler) {
        super.setScheduler(scheduler);
        this.conf = this.getScheduler().getSuperplan().getShopConf();
        this.plan = this.getScheduler().getSuperplan().getPlan();
        long fix = scheduler.getSuperplan().getFixationDate();
        if (!GeneralizedRequest.isDateValid(fix)) {
            fix = 0L;
        }
        for (Workplace wp : scheduler.getSuperplan().getShopConf().getWorkplaces()) {
            this.workplaceBounds.put(wp, wp.isCumulative() ? fix : this.firstBubbleStart(wp, fix));
        }
    }

    @Override
    public void setSuccessors(List<Processor> successors) {
        super.setSuccessors(successors);
        this.checkOneSuccessor();
    }

    @Override
    public void onOperationPlanned(Operation op) {
        Preconditions.checkState(op.isPlanned(), "Operation %s in not planned.", (Object)op);
        for (Operation.WorkplaceSpan wpSpan : op.getPlannings().get(0).getWorkplaceAaSpans()) {
            Workplace opWp = wpSpan.getWorkplace();
            if (opWp.isCumulative()) {
                this.onCumOperationPlanned(op, opWp, wpSpan.getStart(), wpSpan.getEnd());
                continue;
            }
            this.onNormalOperationPlanned(op, opWp, wpSpan.getEnd());
        }
    }

    private void onNormalOperationPlanned(Operation pOp, Workplace wp, long end) {
        long bound = this.firstBubbleStart(wp, end);
        this.workplaceBounds.put(wp, bound);
        this.removeFromPossibleWps(pOp);
        for (Operation op : this.workplaceOperations.get(wp)) {
            op.updateCompositeBound(this, wp, bound);
        }
    }

    private void onCumOperationPlanned(Operation pOp, Workplace wp, long start, long end) {
        CumulativeAction pOpAct = (CumulativeAction)pOp.getAction();
        ActionActivity aa = Util.getLastPlannedAa(pOp);
        Plan plan = this.getScheduler().getSuperplan().getPlan();
        WorkplaceActivity cwa = plan.getWorkplaceSchedule(wp).getActivity(aa.getStart(), WorkplaceSchedule.ActivityMatch.START_INCLUSIVE);
        boolean cwaFull = cwa instanceof CumulativeWorkplaceActivity && ((CumulativeWorkplaceActivity)cwa).getConsumption() > 0.9999999;
        String cumType = pOpAct.getCumulationType();
        String rebuildType = pOpAct.getRebuildType();
        long productionTime = pOpAct.getProductionTime();
        for (Operation op : this.workplaceOperations.get(wp)) {
            CumulativeAction opAct = (CumulativeAction)op.getAction();
            if (productionTime != opAct.getProductionTime() || !cumType.equals(opAct.getCumulationType()) || !rebuildType.equals(opAct.getRebuildType())) continue;
            op.updateCompositeBound(this, wp, cwaFull ? end : start);
        }
    }

    @Override
    public Tuple<Processor, Set<Operation>> process(Set<Operation> ops) {
        if (ops instanceof ChangeTrackingSet) {
            ChangeTrackingSet.Changes changes = ((ChangeTrackingSet)ops).getChanges();
            for (Operation op : changes.getAdded()) {
                for (Workplace wp : this.getPossibleWorkplaces(op)) {
                    op.updateCompositeBound(this, wp, this.workplaceBounds.get(wp));
                    this.workplaceOperations.put(wp, op);
                }
                this.outputOps.add(op);
            }
            for (Operation op : changes.getRemoved()) {
                this.outputOps.remove(op);
                for (Workplace wp : this.getPossibleWorkplaces(op)) {
                    this.workplaceOperations.remove(wp, op);
                }
            }
            return Tuple.create(this.getDefaultSuccessor(), this.outputOpsView);
        }
        for (Operation op : ops) {
            for (Workplace wp : this.getPossibleWorkplaces(op)) {
                op.updateCompositeBound(this, wp, this.workplaceBounds.get(wp));
            }
        }
        return Tuple.create(this.getDefaultSuccessor(), ops);
    }

    private Iterable<Workplace> getPossibleWorkplaces(Operation op) {
        List<Workplace> res = this.conf.getWorkplaces(op.getAction().getCapabilityReq());
        Preconditions.checkState(!res.isEmpty(), "Operation %s cannot be positioned on any workplace.", (Object)op);
        return res;
    }

    private void removeFromPossibleWps(Operation op) {
        for (Workplace wp : this.getPossibleWorkplaces(op)) {
            this.workplaceOperations.remove(wp, op);
        }
    }

    @VisibleForTesting
    protected long firstBubbleStart(Workplace wp, long t) {
        WorkplaceActivity wpa;
        long res = t;
        Iterator<WorkplaceActivity> it = this.plan.getWorkplaceSchedule(wp).forwardIterator(t, true);
        while (it.hasNext() && (wpa = it.next()).getStart() <= res) {
            res = wpa.getEnd();
        }
        return res;
    }
}

